/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grspcmat.cpp,v 1.1 2002-08-29 11:42:59+02 renz Exp $ 

$Id: grspcmat.cpp,v 1.1 2002-08-29 11:42:59+02 renz Exp $ 

$Log: grspcmat.cpp,v $
Revision 1.1  2002-08-29 11:42:59+02  renz
Added RCS Headers
This class is the MSC-Matrix of the old GRSpaceForceFunction
This class is ready for the neighborhood-spacing-error-stuff.
 

$Author: renz $ 

$Date: 2002-08-29 11:42:59+02 $ 

$Locker:  $ 

$Revision: 1.1 $ 

$Name:  $ 

$RCSfile: grspcmat.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grspcmat.cpp,v $ 

*/
#include "GrphclRp\GrphclOb\GRSpcMat.h"
#include "GRPHCLRP\GRPHCLOB\GRSpring.h"
#include <malloc.h>
#include <memory.h>
#include <math.h>

#define NVALUESINMSCMATRIX 6


GRSpacingMatrix::GRSpacingMatrix()
{
	mscmatmemsize = 50;
	mscmatrealsize = 0;

	mscmat = (double *) malloc(mscmatmemsize * NVALUESINMSCMATRIX * 
		sizeof(double));

	memset(mscmat,0,mscmatmemsize* NVALUESINMSCMATRIX *sizeof(double));

	myneighbours = NULL;
	myneighboursright = NULL;

	lastleft = -1;
	lastright = -1;

}

GRSpacingMatrix::~GRSpacingMatrix()
{
	if (mscmat)
		free(mscmat);

	if (myneighbours)
		delete myneighbours;

	if (myneighboursright)
		delete myneighboursright;

}

// this routine resizes the matrix if necessary
double * GRSpacingMatrix::resizeMSCMatrix(int newrealsize)
{
	if (newrealsize > mscmatmemsize)
	{
		int newmemsize = newrealsize + 10;
		double *newmat = (double *) malloc(newmemsize *
			NVALUESINMSCMATRIX * sizeof(double));


		memset(newmat,0,sizeof(double)*newmemsize*NVALUESINMSCMATRIX);
		// kopiere alte matrixeintrge ...
		// das ist natrlich falsch ....
		// warum?
		int i;
		int j;
		for (i=0;i<mscmatmemsize;i++)
		{
			for (j=0;j<NVALUESINMSCMATRIX;j++)
			{
				*(newmat + i + j*newmemsize) = *(mscmat + i +
					j*mscmatmemsize);
			}
		}

		mscmatmemsize = newmemsize;

		double *oldmat = mscmat;
		mscmat = newmat;

		if (oldmat)
			free(oldmat);
	}

	mscmatrealsize = newrealsize;

	return mscmat;
}

double GRSpacingMatrix::getMSCMatrix(int i,int j) const
{
	if (i>=0 && i< mscmatrealsize &&
		j>=0 && j< NVALUESINMSCMATRIX)
	{
		return *(mscmat + i + j*mscmatmemsize); 
	}
	return 0;
}

void GRSpacingMatrix::setMSCMatrix(int i,int j,double value)
{
	if (i>=0 && i< mscmatrealsize &&
		j>=0 && j< NVALUESINMSCMATRIX)
	{
		*(mscmat + i + j*mscmatmemsize) = value;
	}

}

double * GRSpacingMatrix::getMSCMatrix()
{
	return mscmat;

}

int GRSpacingMatrix::getMSCMatrixMemSize()
{

	return mscmatmemsize;
}

int GRSpacingMatrix::getMSCMatrixRealSize()
{
	return mscmatrealsize;

}

void GRSpacingMatrix::AddNeighbourList(KF_List<int> *nl)
{
	// the neighbourlist ....
	if (!myneighbours)
	{
		// owns elements ....
		myneighbours = new listofpointerstointlists(1);
		myneighbours->AddTail(nl);
		lastleft = nl->GetHead();

		myneighboursright = new listofpointerstointlists(0);
		myneighboursright->AddTail(nl);
		lastright = nl->GetTail();
		return;
	}

	POSITION pos,prevpos;

	int newleft = nl->GetHead();
	int newright = nl->GetTail();

	if (newleft >= lastleft)
	{
		lastleft = newleft;
		myneighbours->AddTail(nl);
		goto addright;
	}

	// find the right position to put the thing in;
	// only the first value matters ....
	pos = myneighbours->GetHeadPosition();
	while (pos)
	{
		prevpos = pos;
		intlist *curlist = myneighbours->GetNext(pos);
		if (curlist)
		{
			int left = curlist->GetHead();

			if (newleft <= left)
			{
				// then we are in for it ....
				myneighbours->AddElementAt(prevpos,nl);
				goto addright;
			}

			
		}
	}

	
addright:

	// now we look where to put the right element ...
	if (newright <= lastright)
	{
		lastright = newright;
		myneighboursright->AddTail(nl);
		return;
	}

	// find the right position to put the thing in;
	// only the first value matters ....
	pos = myneighboursright->GetHeadPosition();
	while (pos)
	{
		prevpos = pos;
		intlist *curlist = myneighboursright->GetNext(pos);
		if (curlist)
		{
			int right = curlist->GetTail();

			if (newright >= right)
			{
				// then we are in for it ....
				myneighboursright->AddElementAt(prevpos,nl);
				break;
			}

			
		}
	}

}

// this routine now checks, wether
// any neighbours have "funny" 
// spacing; this means that the
// spring-constants do not match ...
void GRSpacingMatrix::CheckNeighbours(ISpringVector *sprvect)
{
	if (!myneighbours) 
		return;

	// create a new list 
	// does not own the pointers ...
	listofpointerstointlists *errlist = new listofpointerstointlists(0);


	// additionally, we check the variance (difference from the 
	// mean/average-value)
	POSITION pos = myneighbours->GetHeadPosition();
	while (pos)
	{
		float value = 0.0;
		float logvalue = 0;
		float diffpartial = 0;
		float checkval = 0.0;
		float logcheckval = 0;
		float average = 0;
		int   numvalues = 0;
		float min = 1e10;
		float max = 0;
		int haserror = 0;
		int allHaveDurElements = 1;
		intlist *curlist = myneighbours->GetNext(pos);
		if (curlist)
		{
			POSITION pos2 = curlist->GetHeadPosition();
			int i1 = -1;
			int i2 = -1;
			int first = 1;
			while (pos2)
			{
				i1 = i2;
				if (i1 == -1)
				{	
					i1 = curlist->GetNext(pos2);
					ASSERT(pos2);
				}
				i2 = curlist->GetNext(pos2);

				checkval = 0.0;
				// now we check 
				int cnt;
				for (cnt=i1;cnt<i2;cnt++)
				{
					float val = *(mscmat + cnt + mscmatmemsize*3);
/*					GRSpring *spr = sprvect->Get(cnt);
					if (spr)
					{
						if (!spr->hasDurElement)
						{
							// then we need to check all other
							// springs, if we have one with
							// the same duration with an element ...
							int j;
							int found = 0;
							for (j=i1;j<i2;j++)
							{
								if (j == cnt) continue;
								GRSpring *spr2 = sprvect->Get(j);
								if (spr2)
								{
									if (!spr2->hasDurElement) continue;
									if (spr2->getDuration() == spr->getDuration())
									{
										found = 1;
										break;
									}
								}
							}
							if (found)
							{

							}
							else
							{
								allHaveDurElements = 0;
							}

						}
					} */

					if (val < min)
						min  = val;
					if (val > max)
						max = val;
					checkval += val;
					average += val;
					numvalues++;
				}

				checkval = checkval / (i2-i1);

				// now we build the log-value of the 
				// partial average

				logcheckval = log(checkval)/log(2);

				// now we check the 

				if (first)
				{
					value = checkval;
					logvalue = logcheckval;
					first = 0;
				}
				else
				{
					if (value != checkval)
					{
						// then we have an error in this
						// neighbourhood!

						float tmpdiff = logcheckval - logvalue;
						if (tmpdiff < 0)
							tmpdiff *= -1;
						if (tmpdiff > diffpartial)
							diffpartial = tmpdiff;

						// then we determine the difference 
						haserror = 1;

						// errlist->AddTail(curlist);
						
						// break;
					}
				}
			}

			if (haserror) //  && !allHaveDurElements) 
			{
				// now we have to check  the variance
				average = average / numvalues;

				float log2 = log(2);

				float logaverage = log(average) / log2;
				float logmax = log(max) / log2;
				float logmin = log(min) / log2;

				float diff1 = logmax - logaverage;
				float diff2 = logaverage - logmin;
				float diff3 = logmax - logmin;

		/*		if (diffpartial >= 1)
				{
					// then we do not put the list in the errorlist
				}
				else */
				{
					errlist->AddTail(curlist);

				}

			}
		}
		

	}

	if (errlist->GetCount() == 0)
	{
		// we have not found a neighbourhoodviolation ...
		delete errlist;
		return;
	}

	// else, we have an error-spacing somewhere.
	// now, we have to find out, which ranges to 
	// to adjust ...
	// this is done by looking if the range is already
	// extended enough .... // the BRUTE FORCE approach
	// is to compare each of the errlist entries to 
	// all of the neighbourhoodlists and to
	// to extend the entries, if they match ....
	// in order for this to work, the 
	// list must be sorted .....

	listofpointerstointlists *errlist2 = new listofpointerstointlists(1);

	pos = errlist->GetHeadPosition();
	int lastleft = -1;
	while (pos)
	{
		// we iterate through the errorlist ...
		intlist *curlist = errlist->GetNext(pos);
		if (curlist)
		{
			int left = curlist->GetHead();
			int right = curlist->GetTail();

			POSITION pos2 = myneighbours->GetHeadPosition();
			while (pos2)
			{
				intlist *complist = myneighbours->GetNext(pos2);
				if (complist)
				{
					int compleft = complist->GetHead();
					int compright = complist->GetTail();

					if (compright > left && compleft < right)
					{
						//if (compleft < left)
						//	left = compleft;
						if (compright > right)
							right = compright;
					}
				}
			}

			pos2 = myneighboursright->GetHeadPosition();
			while (pos2)
			{
				intlist *complist = myneighboursright->GetNext(pos2);
				if (complist)
				{
					int compleft = complist->GetHead();
					int compright = complist->GetTail();

					if (compright > left && compleft < right)
					{
						if (compleft < left)
							left = compleft;
						//if (compright > right)
						//	right = compright;
					}
				}
			}

			if (left == lastleft)
			{
				// in this case, the last addition was similar
				// to the one that was being added ....
			}
			else
			{
			  // then we add that element ....
			  intlist *newlist = new intlist;
			  newlist->AddTail(left);
			  newlist->AddTail(right);
			  errlist2->AddTail(newlist);
			  lastleft = left;
			}
		}
	}

	// we don't need errlist any longer
	delete errlist;

	// now we need to sort the errlist2 and
	// then we have what we want ....

	// we should have a complete errlist2 ....

	// we could do something with "partial" averages
	// have thought about how to exactly calculate this
	// Nevertheless, it seems to be sufficient to just
	// build the averages that are present at the springs
	// at this time ....


	// we can compare the effect of the "old" gourlay-
	// spring-constants and of the new, average (or maximum)
	// spacing. 
	// then we can compare the effect of a "normal" force
	// and see the difference.


	pos = errlist2->GetHeadPosition();
	while (pos)
	{
		intlist *curlist = errlist2->GetNext(pos);

		int left = curlist->GetHead();
		int right= curlist->GetTail();

		int cnt;
		double average = 0;
		float max = 0;
		float oldconst = 0;
		float sumsprdur = 0;
		float newmaxconst = 0;
		float newaverageconst = 0;
		int first = 1;
		for (cnt=left;cnt<right;cnt++)
		{
			float val = *(mscmat + cnt + mscmatmemsize*3); 
			GRSpring *spr = sprvect->Get(cnt);
			if (spr)
			{
				TYPE_DURATION myfrac(val);
				const TYPE_DURATION & dur = spr->getDuration();
				myfrac.invert();
				float sconst = GRSpring::defconst(myfrac);
				sconst *= (float) myfrac / (float) dur;

				if (first)
				{

					oldconst = sconst;
					first = 0;
				}
				else
				{
					oldconst = 1.0 / (1.0/oldconst + 1.0/sconst);
				}

				sumsprdur += (float) dur;
			}
			// we just take the values from the matrix
			// and build the average ...
			average += *(mscmat + cnt + mscmatmemsize*3);
			if (*(mscmat + cnt + mscmatmemsize*3) > max)
			{
				max = *(mscmat	+ cnt + mscmatmemsize*3);
			}

		}

		average /= (right-left);


		{
		TYPE_DURATION myfrac(max);
		myfrac.invert();
		float sconst = GRSpring::defconst(myfrac);
		newmaxconst = 1.0 / (sumsprdur / sconst * max );
		}

		{
		TYPE_DURATION myfrac(average);
		myfrac.invert();
		float sconst = GRSpring::defconst(myfrac);
		newaverageconst = 1.0 / (sumsprdur / sconst * average );
		}
		// now I have the oldconst and the newconst
		// and I can compare them ....


		float diff = oldconst - newaverageconst;
		if (diff < 0)
			diff *= -1;
		int doit = 0;
		float value;
		if (diff< 0.05)
		{
			doit = 1;
			value = average;
		}
		else
		{
			diff = oldconst - newmaxconst;
			if (diff < 0)
				diff *= -1;
			if (diff < 0.17)
			{
				doit = 1;
				value = max;
			}
		}
		
		if (doit)
		{
			for (cnt=left;cnt<right;cnt++)
			{
#ifdef _DEBUG
				GRSpring *spr = sprvect->Get(cnt);
#endif
				// we just take the values from the matrix
				// and build the average ...
				*(mscmat + cnt + mscmatmemsize*3) = value; // max; // average;
			}
		}

	}


	delete errlist2;

	
}